%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function mesh = readmesh3(filebase);

% Filenames

type1 = 'mesh';

file = sprintf('%s.%s',filebase,type1);


    

[num_nodes, num_ele] = textread(file,'%d %d',1);

nodes = zeros(num_nodes,3);
[nodes(:,1), nodes(:,2), nodes(:,3)] = textread(file,'%*d %f %f %f %*d',...
  num_nodes,'headerlines',1);

boundary = zeros(num_nodes,1);
boundary = textread(file, '%*d %*f %*f %*f %d',num_nodes,'headerlines',1);
    
ele=zeros(num_ele,4);
[ele(:,1), ele(:,2), ele(:,3), ele(:,4)] = textread(file,'%*d %d %d %d %d',...
  num_ele,'headerlines',num_nodes+1);

ele(:,:)=ele(:,:)+1;

mesh = struct('coords',nodes,'tris',ele,'border',boundary);
